package gov.va.med.mhv.usermgmt.essapi.transfer;

import java.util.Date;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.enumeration.CountryEnum;
import gov.va.med.mhv.common.api.enumeration.ErrorEnum;
import gov.va.med.mhv.common.api.enumeration.StateEnum;
import gov.va.med.mhv.common.api.util.MHVApiUtility;
import gov.va.med.mhv.common.api.util.MHVEssApiUtility;
import gov.va.med.mhv.common.data.converter.UserProfileConverter;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.common.data.util.SsnFormatter;
import gov.va.med.mhv.core.validate.EmailValidator;
import gov.va.med.mhv.usermgmt.common.enums.ContactMethodEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.CountryEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.Gender;
import gov.va.med.mhv.usermgmt.common.enums.GenderEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.StateEnumeration;
import gov.va.med.mhv.usermgmt.essapi.service.util.RandomUserNameGenerator;
import gov.va.med.mhv.usermgmt.util.mvi.MviConstants;

@Component
public class UserProfileAPIConverter {

	@Autowired
	private UserProfileConverter converter;
	
	public UserProfile convertDomainProfile(UserProfile domainObject, RegisterTO registerTO, HashMap<String, Object> patientInfoMap) {

		if (isCheckNullOrEmpty(registerTO.getCity()) 		||	isCheckNullOrEmpty(registerTO.getCountry()) 		
				 
			)	 {
			MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
		}
		
		if(isCheckNullOrEmpty(registerTO.getState()) && isCheckNullOrEmpty(registerTO.getProvince()) )
			MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
		
		//Set First name & Last Name
		domainObject.setFirstName((String)patientInfoMap.get(MviConstants.FIRST_NAME));
		domainObject.setLastName((String)patientInfoMap.get(MviConstants.LAST_NAME));
		
		//Set Birth Date
		domainObject.setBirthDate((Date)patientInfoMap.get(MviConstants.BIRTH_DAY));
		
		//Set SSN
		domainObject.setSsn((String)patientInfoMap.get(MviConstants.SSN));
		
		//Set Gender
			Gender gender = (Gender)patientInfoMap.get(MviConstants.GENDER);
			domainObject.setGender(gender.getName());
			
		
		//Set Contact Preference
		if(registerTO.getContactMethod() == null) {
			registerTO.setContactMethod(ContactMethodEnumeration.Email.name());
			if (!isValidEmail(registerTO.getEmail()))
				MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
			else if(!gov.va.med.mhv.core.validate.EmailValidator.isValid(registerTO.getEmail() ) ) {
				MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);	
			}
		}
		
		domainObject.setContactInfoContactMethod(registerTO.getContactMethod());	
	
			switch (ContactMethodEnumeration.valueOf((registerTO.getContactMethod()))) {
				case Email: 
					domainObject.setContactInfoEmail(registerTO.getEmail());
					break;
				case Fax:
					domainObject.setContactInfoFax((registerTO.getFax()));
					break;
				case HomePhone:
					domainObject.setContactInfoHomePhone(registerTO.getContactMethod());
					break;
				case MobilePhone:
					domainObject.setContactInfoMobilePhone(registerTO.getMobilePhone());
					break;
				case Pager:
					domainObject.setContactInfoPager(registerTO.getPager());
					break;
				case WorkPhone:
					domainObject.setContactInfoWorkPhone(registerTO.getWorkPhone());
					break;
					
				default:
						domainObject.setContactInfoEmail(registerTO.getEmail());
						break;
			}
		
		
		//set UserName
//		if (domainObject.getUserName() == null)
//			domainObject.setUserName(RandomUserNameGenerator.userNameGenerate(registerTO.getFirstName(), registerTO.getLastName(), registerTO.getBirthDate()));
//		
			domainObject.setCreatedDate(new Date(System.currentTimeMillis()));
			converter.generateMhvId(domainObject);	
		
		//set Disclaimer and Terms
		domainObject.setAcceptDisclaimer(true);
		domainObject.setAcceptTerms(true);
		//TODO: T&C Entries
		
		//set SM Terms and SIPAccess
		domainObject.setAcceptSMTerms(true);
		domainObject.setRestrictSIPAccess(false);
		
		//Set Privacy
		domainObject.setAcceptPrivacy(true);
		
		//Set Relationship VA
		domainObject.setIsPatient(registerTO.getIsPatient());
		domainObject.setIsChampVABeneficiary(registerTO.getIsChampVABeneficiary());
		domainObject.setIsEmployee(registerTO.getIsEmployee());
		domainObject.setIsHealthCareProvider(registerTO.getIsHealthCareProvider());
		domainObject.setIsOther(registerTO.getIsOther());
		domainObject.setIsPatientAdvocate(registerTO.getIsPatientAdvocate());
		domainObject.setIsServiceMember(registerTO.getIsServiceMemeber());
		domainObject.setIsVeteran(registerTO.getIsVeteran());
		
		
		//set Address
		domainObject.setAddressStreet1(registerTO.getAddress1());
		domainObject.setAddressStreet2(registerTO.getAddress2());
		domainObject.setAddressCity(registerTO.getCity());
		domainObject.setAddressCountry(CountryEnum.valueOfAbbreviation(registerTO.getCountry()).getCountryDetailName());
		domainObject.setAddressPostalCode(registerTO.getZip());
		
//		if (registerTO.getCountry().equalsIgnoreCase(CountryEnumeration.UNITED_STATES.getDescription())) {
//			domainObject.setAddressState(StateEnumeration.valueOf(registerTO.getState()).getDescription());
//			if (domainObject.getAddressState() == null)
//				MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
//		}
		if (registerTO.getCountry().equalsIgnoreCase(CountryEnum.UNITED_STATES.getCountryCode())) {
			domainObject.setAddressState(StateEnum.valueOfAbbreviation(registerTO.getState()).getStateCode());
			if (domainObject.getAddressState() == null)
				MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
		}
		else {
			domainObject.setAddressProvince(registerTO.getProvince());
			if (domainObject.getAddressProvince() == null)
				MHVEssApiUtility.throwException(ErrorEnum.USER_REGISTRATION_INVALID_INPUT);
		}
		
		//setting Oplock because its not version.. God knows WHY..
	//	domainObject.setOplock(1);
		
		return domainObject;
		
	}
	
	private boolean isCheckNullOrEmpty(String objStr) {
		if(objStr == null || objStr.trim().isEmpty()) {
			return true;
		}
		else {
			return false;
		}
		
	}
	private boolean isValidEmail(String email) {
		return EmailValidator.isValid(email);
		
	}
	
}
